﻿using System;

namespace Counters
{
    public struct Counter
    {
        private readonly int _count;
        private static int _totalCount;

        private Counter(int count)
        {
            _count = count;
        }

        public Counter GetNextValue()
        {
            _totalCount += 1;
            return new Counter(_count + 1);
        }

        public static Counter operator ++(Counter input)
        {
            return input.GetNextValue();
        }

        public int Count
        {
            get
            {
                return _count;
            }
        }

        public static int TotalCount
        {
            get
            {
                return _totalCount;
            }
        }

        // Listing 3-11
        public static bool operator ==(Counter x, Counter y)
        {
            return x.Count == y.Count;
        }

        public static bool operator !=(Counter x, Counter y)
        {
            return x.Count != y.Count;
        }

        public override bool Equals(object obj)
        {
            if (obj is Counter)
            {
                Counter c = (Counter) obj;
                return c.Count == this.Count;
            }
            else
            {
                return false;
            }
        }

        public override int GetHashCode()
        {
            return _count;
        }
    }
}
